/*
 * Decompiled with CFR 0.152.
 */
package update;

import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javafx.stage.Window;
import nativeWindows.NativeLauncher;
import tools.Read;

public class Updater {
    private static String[] versionInfo;

    private static void getVersionInfo(String url) {
        try {
            versionInfo = Read.readFromURL(url);
        }
        catch (Exception e) {
            versionInfo = null;
        }
    }

    private static int getVersion() {
        if (versionInfo == null) {
            return -1;
        }
        return Integer.parseInt(versionInfo[0]);
    }

    private static String getDownloadPath() {
        if (versionInfo == null) {
            return null;
        }
        return versionInfo[1];
    }

    private static void update(String appName, String folderName) throws Exception {
        String savePath = "";
        String url = Updater.getDownloadPath();
        String pathToUpdater = "";
        if (folderName == null) {
            savePath = String.valueOf(System.getenv("APPDATA")) + "\\" + appName + "\\";
            pathToUpdater = String.valueOf(System.getenv("APPDATA")) + "\\" + appName + "\\Updater.exe";
        } else {
            savePath = String.valueOf(folderName) + "\\";
            pathToUpdater = String.valueOf(folderName) + "\\Updater.exe";
        }
        savePath = savePath.replace(" ", "%20");
        System.out.println("savePath: " + savePath + " appName: " + appName + " url: " + url + " pathToUpdater: " + pathToUpdater);
        String params = String.valueOf(savePath) + " " + appName + " " + url;
        NativeLauncher.executeAsAdministrator(pathToUpdater, params);
        System.exit(0);
    }

    public static boolean checkForUpdates(String urlToVersionInfo, String appName, String folderName, int currentVersion, Stage stage, Image icon) {
        Updater.getVersionInfo(urlToVersionInfo);
        int version = Updater.getVersion();
        if (version > 0) {
            if (Updater.getVersion() > currentVersion) {
                Platform.runLater(() -> {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                    alert.setTitle("Update");
                    alert.setHeaderText("");
                    alert.setContentText("Ein Update ist verf\u00fcgbar. Jetzt herunterladen?");
                    alert.initOwner((Window)stage);
                    Stage dialogStage = (Stage)alert.getDialogPane().getScene().getWindow();
                    dialogStage.getIcons().add((Object)icon);
                    ButtonType buttonTypeOne = new ButtonType("Aktualisieren");
                    ButtonType buttonTypeTwo = new ButtonType("Abbrechen");
                    alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOne, buttonTypeTwo});
                    Optional result = alert.showAndWait();
                    if (result.get() == buttonTypeOne) {
                        try {
                            Updater.update(appName, folderName);
                        }
                        catch (Exception e) {
                            alert.close();
                            Alert alert2 = new Alert(Alert.AlertType.ERROR);
                            alert2.setTitle("Fehler");
                            alert2.setHeaderText("");
                            alert2.setContentText("Update konnte nicht gestartet werden!");
                            alert2.initOwner((Window)stage);
                            Stage dialogStage2 = (Stage)alert2.getDialogPane().getScene().getWindow();
                            dialogStage2.getIcons().add((Object)icon);
                            alert2.showAndWait();
                        }
                    } else {
                        alert.close();
                    }
                });
                return true;
            }
            return false;
        }
        return false;
    }
}

